CREATE DATABASE IF NOT EXISTS db_sekolah_full;
USE db_sekolah_full;

-- 1. Tabel Admin & User
CREATE TABLE admin (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50),
    password VARCHAR(255),
    nama VARCHAR(100),
    role ENUM('Kepala Sekolah', 'Admin TU', 'Pustakawan')
);
INSERT INTO admin VALUES (1, 'admin', 'admin123', 'Budi Santoso', 'Admin TU');

-- 2. Tabel Siswa
CREATE TABLE siswa (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nis VARCHAR(20),
    nama VARCHAR(100),
    kelas VARCHAR(10),
    status VARCHAR(20) DEFAULT 'Aktif'
);
INSERT INTO siswa VALUES 
(1, '1001', 'Ahmad Dani', 'X-A', 'Aktif'),
(2, '1002', 'Citra Kirana', 'XI-IPA', 'Aktif');

-- 3. Tabel Guru (SDM)
CREATE TABLE guru (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nip VARCHAR(30),
    nama VARCHAR(100),
    mapel VARCHAR(50),
    status_absen VARCHAR(20) DEFAULT 'Hadir'
);
INSERT INTO guru VALUES 
(1, '19850101', 'Pak Suherman', 'Matematika', 'Hadir'),
(2, '19900202', 'Bu Lina', 'Biologi', 'Izin');

-- 4. Tabel Akademik (Nilai)
CREATE TABLE nilai (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_siswa INT,
    mapel VARCHAR(50),
    nilai_uh INT,
    nilai_uts INT,
    nilai_uas INT
);
INSERT INTO nilai VALUES (1, 1, 'Matematika', 80, 85, 90);

-- 5. Tabel Kesiswaan (Pelanggaran BK)
CREATE TABLE pelanggaran (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_siswa INT,
    kasus VARCHAR(100),
    poin INT,
    tanggal DATE
);
INSERT INTO pelanggaran VALUES (1, 1, 'Terlambat Sekolah', 5, '2023-10-01');

-- 6. Tabel Keuangan (SPP)
CREATE TABLE spp (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_siswa INT,
    bulan VARCHAR(20),
    jumlah INT,
    status VARCHAR(20)
);
INSERT INTO spp VALUES (1, 2, 'Oktober 2023', 150000, 'Lunas');

-- 7. Tabel Perpustakaan (Buku)
CREATE TABLE buku (
    id INT AUTO_INCREMENT PRIMARY KEY,
    judul VARCHAR(100),
    pengarang VARCHAR(100),
    stok INT
);
INSERT INTO buku VALUES (1, 'Laskar Pelangi', 'Andrea Hirata', 5), (2, 'Biologi Kelas X', 'Erlangga', 20);

-- 8. Tabel Sarpras (Inventaris)
CREATE TABLE inventaris (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_barang VARCHAR(100),
    lokasi VARCHAR(50),
    kondisi ENUM('Baik', 'Rusak Ringan', 'Rusak Berat')
);
INSERT INTO inventaris VALUES 
(1, 'Proyektor Epson', 'Lab Komputer', 'Baik'),
(2, 'Meja Guru', 'Ruang 101', 'Rusak Ringan');